#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct Jar { ll x, h; };

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;
    vector<Jar> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i].x;
    for (int i = 0; i < n; ++i) cin >> a[i].h;

    sort(a.begin(), a.end(), [](const Jar &A, const Jar &B){ return A.x < B.x; });

    const ll INF = (ll)4e18;
    vector<ll> ans(n, INF);

    {
        stack<int> st;
        for (int i = 0; i < n; ++i) {
            while (!st.empty() && a[st.top()].h <= a[i].h) {
                int j = st.top(); st.pop();
                ans[j] = min(ans[j], llabs(a[i].x - a[j].x));
            }
            st.push(i);
        }
    }

    {
        stack<int> st;
        for (int i = n-1; i >= 0; --i) {
            while (!st.empty() && a[st.top()].h <= a[i].h) {
                int j = st.top(); st.pop();
                ans[j] = min(ans[j], llabs(a[i].x - a[j].x));
            }
            st.push(i);
        }
    }

    for (int i = 0; i + 1 < n; ++i) {
        ll xL = a[i].x, hL = a[i].h;
        ll xR = a[i+1].x, hR = a[i+1].h;
        ll X = (xL + hL + xR - hR) / 2;
        if (hL >= a[i].h) {
        }

        if (hR >= a[i].h) {
            ll x_candidate = xR - (hR - a[i].h);
            if (x_candidate >= X && x_candidate >= xL && x_candidate <= xR) {
                ans[i] = min(ans[i], llabs(x_candidate - a[i].x));
            }
        }

        if (hL >= a[i+1].h) {
            ll x_candidate = xL + (hL - a[i+1].h);
            if (x_candidate <= X && x_candidate >= xL && x_candidate <= xR) {
                ans[i+1] = min(ans[i+1], llabs(x_candidate - a[i+1].x));
            }
        }
    }
    for (int i = 0; i < n; ++i) {
        if (ans[i] >= (ll)3e18) cout << -1 << '\n';
        else cout << ans[i] << '\n';
    }
    return 0;
}